<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\storeServiceRequest;
use App\Http\Requests\updateServiceRequest;
use App\Models\Direction;
use App\Models\Service;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ServiceController extends Controller
{
    public function index()
    {
        $services = Service::with('direction')
        ->where('etat', 1)
        ->paginate(10);
        return view('backend.pages.services.list', compact('services'));
    }

    public function create()
    {
        $directions = Direction::all();
        return view('backend.pages.services.add', compact('directions'));
    }

    public function store(Service $service, storeServiceRequest $request)
    {
        // dd($request->all());
        try {
            $service->id_direction = $request->id_direction;
            $service->nom = $request->nom;
            $service->email = $request->email;
            $service->telephone = $request->telephone;
            $service->localisation = $request->localisation;
            $service->mission = $request->mission;
            $service->user_id = Auth::id();
            $service->save();          
            return redirect()->route('service.index')->with('success', 'Service enrégistré avec succès !');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreure est survenue lors de l'enregistrement du service");
        }
        
    }

    public function edit(Service $service)
    {
        $directions = Direction::all();
        return view('backend.pages.services.edit', compact('service', 'directions'));
    }

    public function update(Service $service, updateServiceRequest $request)
    {
        try {
            $service->id_direction = $request->id_direction;
            $service->nom = $request->nom;
            $service->email = $request->email;
            $service->telephone = $request->telephone;
            $service->localisation = $request->localisation;
            $service->mission = $request->mission;
            $service->update();          
            return redirect()->route('service.index')->with('success', 'Service modifié avec succès !');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreure est survenue lors de l'enregistrement du service");
        }

        
    }


    public function delete(Service $service)
    {
        try {
            $service->etat = 0;
            $service->save();
            return redirect()->route('service.index')->with('success', 'Service supprimé avec succès!');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreur est survenue lors de la suppression de la direction");
        }
    }



}
