<?php

namespace App\Http\Controllers\Backend;

use Exception;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\Admin\RoleRequest;
use Spatie\Permission\Models\Permission;
use App\Http\Requests\Admin\PermissionRequest;

class RolesController extends Controller
{
    public function index()
    {
        if (Auth::check()) {
            $roles = Role::all();
            return view('backend.pages.roles.list-of-roles', compact('roles'));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function add() 
    {
        if (Auth::check()) {
            return view('backend.pages.roles.add-role');
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function store(RoleRequest $request)
    {
        try {
            $role = Role::where('name', $request->role_name)->first();
            if ($role) {
                return back()->with('error', 'Un rôle avec le même nom existe déjà.');
            }
            Role::create(['name' => $request->role_name]);
            return back()->with('success', 'Rôle ajouté avec succès.');
        }   
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }

    public function edit(Role $role)
    {
        if (Auth::check()) {
            if ($role->name == 'super_admin') {
                return back()->with('error', "Vous ne pouvez pas modifier le nom du rôle '$role->name'.");
            }
            return view('backend.pages.roles.edit-role', compact('role'));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function update(RoleRequest $request, Role $role)
    {
        try {
            if (Role::where('name', $request->role_name)->first()) {
                return back()->with('error', 'Un rôle avec le même nom existe déjà.');
            }
            $role->update(['name' => $request->role_name]);
            return back()->with('success', 'Rôle modifié avec succès.');
        }
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }

    public function destroy(Role $role)
    {
        try {
            $role = Role::where('name', $role->name)->first();
            if ($role->name != 'super_admin') {
                $role->delete();
                return redirect()->route('admin.role.list')->with('success', 'Rôle supprimé avec succès.');
            }
            return back()->with('error', "Le rôle '$role->name' ne peut pas être supprimé.");
        }
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }

    public function show(Role $role)
    {
        if (Auth::check()) {
            $role = Role::where('name', $role->name)->first();
            $permissions = Permission::all();
            if ($role) {
                return view('backend.pages.roles.show', compact('role', 'permissions'));
            }
            return back()->with('error',"Ce rôle n'exsite pas.");
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function grantPermission(PermissionRequest $request, Role $role)
    {
        try {
            if ($role->hasPermissionTo($request->permission_name)) {
                return redirect()->back()->with('warning', "La permission '$request->permission_name' est déjà accordée à ce rôle.");
            }
            $role->givePermissionTo($request->permission_name);
            return back()->with('success', "Permission accordée avec succès.");
        }
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }

    public function revokePermission(Role $role, Permission $permission)
    {
        try {
            if ($role->hasPermissionTo($permission)) {
                $role->revokePermissionTo($permission);
                return redirect()->back()->with('success', "Permission retirée avec succès.");
            }
            return back()->with('error', "Ce rôle n'a pas la permission '$permission->name'.");
        }
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }
    
}
