<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\storeResponsableRequest;
use App\Http\Requests\updateResponsableRequest;
use App\Models\Fonction;
use App\Models\Responsable;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ResponsableController extends Controller
{
        public function index()
    {
        // Récupérer uniquement les responsables dont l'état est à 1 et charger la relation 'fonction'
        $responsables = Responsable::with('fonction')
            ->where('etat', 1) 
            ->paginate(10);    

        return view('backend.pages.responsables.list', compact('responsables'));
    }

    public function create()
    {
        $fonctions = Fonction::all();
        return view('backend.pages.responsables.add', compact('fonctions'));
    }

    public function store(Responsable $responsable, storeResponsableRequest $request)
    {
        // dd($request->all());
        try {
            $responsable->nom = $request->nom;
            $responsable->prenom = $request->prenom;
            $responsable->email = $request->email;
            $responsable->telephone = $request->telephone;
            $responsable->adresse = $request->adresse;
            $responsable->etat = 1;
            $responsable->id_fonction = $request->id_fonction;
            $responsable->user_id = Auth::id();
            $responsable->save();          
            return redirect()->route('responsable.index')->with('success', 'Responsable enrégistré avec succès !');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreure est survenue lors de l'enregistrement du responsable");
        }
        
    }

    public function edit(Responsable $responsable)
    {
        $fonctions = Fonction::all();
        return view('backend.pages.responsables.edit', compact('responsable', 'fonctions'));
    }

    public function update(Responsable $responsable, updateResponsableRequest $request)
    {
        try {
            $responsable->nom = $request->nom;
            $responsable->prenom = $request->prenom;
            $responsable->email = $request->email;
            $responsable->telephone = $request->telephone;
            $responsable->adresse = $request->adresse;
            $responsable->etat = 1;
            $responsable->id_fonction = $request->id_fonction;
            $responsable->update();         
            return redirect()->route('responsable.index')->with('success', 'Responsable modifié avec succès !');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreure est survenue lors de l'enregistrement du responsable");
        }

        
    }


    public function delete(Responsable $responsable)
    {
        try {
            // Mise à jour de l'état du responsable au lieu de la suppression
            $responsable->etat = 0;
            $responsable->save();

            return redirect()->route('responsable.index')->with('success', 'Responsable désactivé avec succès!');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreur est survenue lors de la désactivation du responsable");
        }
    }

}
