<?php

namespace App\Http\Controllers\Backend;

use Exception;
use App\Models\Entity;
use App\Models\Product;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\Admin\ProductRequest;
use App\Http\Requests\StoreProductRequest;
use App\Http\Requests\UpdatProductRequest;
use App\Models\Produit;
use App\Models\Promoteur;

class ProductController extends Controller
{
    public function index()
    {
        if (Auth::check()) {
            $produits = Produit::with('promoteur')
            ->where('etat', 1) 
            ->paginate(10);
            return view('backend.pages.produits.list', compact('produits'));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function create()
    {
        if (Auth::check()) {
            $promoteurs = Promoteur::all(); // Récupérer tous les promoteurs
            return view('backend.pages.produits.add', compact('promoteurs'));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function store(Produit $produit, StoreProductRequest $request)
    {
        try {
            // Créer un nouveau produit
            $produit = new Produit();
            $produit->nom = $request->nom;
            $produit->id_promoteur = $request->id_promoteur; // Associer le promoteur
            $produit->etat = 1;
            $produit->user_id = Auth::id();
            $produit->save();

            return redirect()->route('produit.index')->with('success', 'Produit enregistré avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de l'enregistrement du produit.");
        }
    }

    public function edit(Produit $produit)
    {
        if (Auth::check()) {
            $promoteurs = Promoteur::all(); // Récupérer tous les promoteurs
            return view('backend.pages.produits.edit', compact('produit', 'promoteurs'));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }
    public function update(UpdatProductRequest $request, Produit $produit)
    {
        try {
            $produit->nom = $request->nom;
            $produit->id_promoteur = $request->id_promoteur; // Mettre à jour le promoteur associé
            $produit->save();

            return redirect()->route('produit.index')->with('success', 'Produit mis à jour avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de la mise à jour du produit.");
        }
    }

    // Désactiver un produit (état = 0)
    public function disable(Produit $produit)
    {
        try {
            $produit->etat = 0; // Désactiver le produit
            $produit->save();

            return redirect()->route('produit.index')->with('success', 'Produit désactivé avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de la désactivation du produit.");
        }
    }
}
