<?php

namespace App\Http\Controllers\Backend;

use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Permission;
use App\Http\Requests\Admin\PermissionRequest;

class PermissionsController extends Controller
{
    public function index()
    {
        if (Auth::check()) {
            $permissions = Permission::all();
            return view("backend.pages.permissions.list-of-permissions", compact("permissions"));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }
    
    public function add()
    {
        if (Auth::check()) {
            return view("backend.pages.permissions.add-permission");
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function store(PermissionRequest $request)
    {
        try {
            $permission = Permission::where('name', $request->permission_name)->first();
            if ($permission) {
                return back()->with('error', "Une permission avec le même nom existe déjà.");
            }
            Permission::create(['name' => $request->permission_name]);
            return back()->with('success', 'Permission ajoutée avec succès.');
        }   
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }

    public function show(Permission $permission)
    {
    }

    public function edit(Permission $permission)
    {
        if (Auth::check()) {
            return view('backend.pages.permissions.edit-permission', compact('permission'));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function update(PermissionRequest $request, Permission $permission)
    {
        try {
            $old_permission = Permission::where('name', $request->permission_name)->first();
            if ($old_permission) {
                return back()->with('error', "Une permission avec le même nom existe déjà.");
            }
            $permission->update(['name' => $request->permission_name]);
            return back()->with('success', 'Permission modifiée avec succès.');
        }
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }

    public function destroy(Permission $permission)
    {
        try {
            $permission = Permission::where('name', $permission->name)->first();
            if ($permission) {
                $permission->delete();
                return redirect()->route('admin.permission.list')->with('success', 'Permission supprimée avec succès.');
            }
            return back()->with('error', "Cette permission n'existe pas.");
        }
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }

}
