<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreMinisterRequest;
use App\Http\Requests\updateMinisterRequest;
use Illuminate\Http\Request;
use App\Models\Ministere;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class MinisterController extends Controller
{
    public function index()
    {
        $ministers = Ministere::where('etat', 1)->paginate(10);
        return view('backend.pages.ministers.list', compact('ministers'));
    }

    public function create()
    {
        return view('backend.pages.ministers.add');
    }

    public function store(Ministere $minister, StoreMinisterRequest $request)
    {
        // dd($request->all());
        try {
            $minister->nom = $request->nom;
            $minister->email = $request->email;
            $minister->telephone = $request->telephone;
            $minister->localisation = $request->localisation;
            $minister->site_web = $request->site_web;
            $minister->mission = $request->mission;
            $minister->logo = "";
            $minister->user_id = Auth::id();
            $minister->save();
            
            $idMinister = $minister->id_ministere;
            $imageE = $request->file('logo');
            if ($imageE) {
                $teaser_imageE = 'mcipme_logo' . $idMinister . '.' . 'png';
                $destinationPathE = public_path('/assets/ministers');
                $imageE->move($destinationPathE, $teaser_imageE);
                DB::table('ministeres')->where('id_ministere', $minister->id_ministere)->update(['logo' => $teaser_imageE]);
            } else {
                return redirect()->back()->with('error', 'Le logo est manquant. Veuillez télécharger un fichier.');
            }
            
            return redirect()->route('minister.index')->with('success', 'Ministère enrégistré avec succès !');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreure est survenue lors de l'enregistrement du ministère");
        }
        
    }

    public function edit(Ministere $minister)
    {
        return view('backend.pages.ministers.edit', compact('minister'));
    }

    public function update(Ministere $minister, updateMinisterRequest $request)
    {
        // dd($request->all());
        try {
            $minister->nom = $request->nom;
            $minister->email = $request->email;
            $minister->telephone = $request->telephone;
            $minister->localisation = $request->localisation;
            $minister->site_web = $request->site_web;
            $minister->mission = $request->mission;
            $minister->logo = "";
            $minister->update();
            
            $idMinister = $minister->id_ministere;
            $imageE = $request->file('logo');
            $teaser_imageE = 'mcipme_logo'.$idMinister . '.' . 'png';
            $destinationPathE = public_path('/assets/ministers');
            $imageE->move($destinationPathE, $teaser_imageE);
            // dd($teaser_imageE);
            DB::table('ministeres')->where('id_ministere', $minister->id_ministere)->update(['logo'=>$teaser_imageE]);
            
            return redirect()->route('minister.index')->with('success', 'Ministère modifié avec succès !');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreure est survenue lors de l'enregistrement du ministère");
        }
    }

    // Désactiver une catégorie de document (état à 0)
    public function delete(Ministere $minister, Request $request)
    {
        try {
            // Définir l'état à 0 pour désactiver la catégorie
            $minister->etat = 0;
            $minister->save();

            return redirect()->route('minister.index')->with('success', 'Ministère supprimé avec succès!');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de la suppression du ministère.");
        }
    }
}
