<?php

namespace App\Http\Controllers\Backend;

use Exception;
use App\Models\User;
use App\Models\FileType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\Admin\FileTypeRequest;

class FileTypeController extends Controller
{
    public function index()
    {
        if (Auth::check()) {
            $fileTypes = FileType::all();
            return view('backend.pages.file-types.list-of-file-types', compact('fileTypes'));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function add()
    {
        if (Auth::check()) {
            return view('backend.pages.file-types.add-file-type');
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }

    public function store(FileTypeRequest $request)
    {
        try {
            $fileType = new FileType();
            $fileType->file_type_name = $request->file_type_name;
            $fileType->description = $request->description ?: NULL;
            $fileType->save();
            return back()->with('success', "Type de Fichier enregistré avec succès!");
        } catch (Exception $e) {
            die($e->getMessage());
        }
    }

    public function edit(FileType $fileType)
    {
        if (Auth::check()) {
            return view('backend.pages.file-types.edit-file-type', compact('fileType'));
        }
        return back()->with('warning', "Vous n'êtes pas connecté.");
    }
    public function update(FileTypeRequest $request, FileType $fileType)
    {
        try {
            if (($request->file_type_name == $fileType->file_type_name) && ($request->description == $fileType->description)) {
                return back()->with('info', "Aucune modification n'a été apportée.");
            }
            $fileType->update([
                'file_type_name' => $request->file_type_name,
                'description' => $request->description,

            ]);
            return back()->with('success', "Type de Fichier modifié avec succès.");
        } catch (Exception $e) {
            die($e->getMessage());
        }
    }

    public function destroy(FileType $fileType)
    {
        try {
            $fileType = FileType::findOrFail($fileType->file_type_id);
            if ($fileType) {
                $fileType->delete();
                return back()->with('success', "Type de Fichier supprimé avec succès!");
            }
            return back()->with('error', "Le type de ficiher que vous essayez de supprimer n'existe pas.");
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }
}
