<?php

namespace App\Http\Controllers\Backend;

use Exception;
use App\Models\Entity;
use App\Models\EntityType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\EntityRequest;

class EntityController extends Controller
{
    public function index()
    {
        $entities = Entity::all();
        return view('backend.pages.entities.list-of-entities', compact('entities'));
    }

    public function add()
    {
        $entityTypes = EntityType::all();
        return view('backend.pages.entities.add-entities', compact('entityTypes'));
    }

    public function store(EntityRequest $request)
    {
        try {
            $entity = new Entity();
            $entity->entity_name = $request->entity_name;
            $entity->entity_type_id = $request->entity_type;
            $entity->save();
            return back()->with('success', 'Entité ajouté avec succès.');
        }   
        catch(Exception $e) {
            dd($e->getMessage());
        }
    }

    public function edit($entity)
    {
        
    }
    public function update(Request $request, $entity)
    {
        
    }

    public function detroy($entity)
    {
        
    }
}
