<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreDirectionRequest;
use App\Http\Requests\updateDirectionRequest;
use App\Models\Direction;
use App\Models\Ministere;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DirectionController extends Controller
{
    public function index()
    {
        $directions = Direction::with('ministere')
        ->where('etat', 1)
        ->paginate(10);
        return view('backend.pages.directions.list', compact('directions'));
    }

    public function create()
    {
    $ministeres = Ministere::all();
     return view('backend.pages.directions.add', compact('ministeres'));
    }

    public function store(Direction $direction, StoreDirectionRequest $request)
    {
        // dd($request->all());
        try {
            $direction->id_ministere = $request->id_ministere;
            $direction->nom = $request->nom;
            $direction->email = $request->email;
            $direction->telephone = $request->telephone;
            $direction->localisation = $request->localisation;
            $direction->site_web = $request->site_web;
            $direction->mission = $request->mission;
            $direction->logo = "";
            $direction->user_id = Auth::id();
            $direction->save();
            
            $idDirection = $direction->id_direction;
            $imageE = $request->file('logo');
            if ($imageE) {
                $teaser_imageE = 'direction_logo' . $idDirection . '.' . 'png';
                $destinationPathE = public_path('/assets/directions');
                $imageE->move($destinationPathE, $teaser_imageE);
                DB::table('directions')->where('id_direction', $direction->id_direction)->update(['logo' => $teaser_imageE]);
            } else {
                return redirect()->back()->with('error', 'Le logo est manquant. Veuillez télécharger un fichier.');
            }
            
            return redirect()->route('direction.index')->with('success', 'Direction enrégistrée avec succès !');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreure est survenue lors de l'enregistrement de la direction");
        }
        
    }

    public function edit(Direction $direction)
    {
        $ministeres = Ministere::all();
        return view('backend.pages.directions.edit', compact('direction', 'ministeres'));
    }

    public function update(Direction $direction, updateDirectionRequest $request)
    {
        try {
            $direction->id_ministere = $request->id_ministere;
            $direction->nom = $request->nom;
            $direction->email = $request->email;
            $direction->telephone = $request->telephone;
            $direction->localisation = $request->localisation;
            $direction->site_web = $request->site_web;
            $direction->mission = $request->mission;
            $direction->logo = "";
            $direction->update();
            
            $idDirection = $direction->id_direction;
            $imageE = $request->file('logo');
            $teaser_imageE = 'direction_logo'.$idDirection . '.' . 'png';
            $destinationPathE = public_path('/assets/directions');
            $imageE->move($destinationPathE, $teaser_imageE);
            // dd($teaser_imageE);
            DB::table('directions')->where('id_direction', $direction->id_direction)->update(['logo'=>$teaser_imageE]);
            
            return redirect()->route('direction.index')->with('success', 'Direction modifiée avec succès !');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreure est survenue lors de l'enregistrement de la direction");
        }

        
    }

    public function delete(Direction $direction, Request $request)
    {
        try {
            $direction->etat = 0;
            $direction->save();
            return redirect()->route('direction.index')->with('success', 'Direction supprimée avec succès!');
        } catch (Exception $e) {
            dd($e);
            throw new Exception("Une erreur est survenue lors de la suppression de la direction");
        }
    }
}
