<?php

namespace App\Http\Controllers\Backend;

use Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Demande;
use App\Models\Direction;
use App\Models\TypeDocument;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        if (Auth::check()) {
            if (Auth::user()->hasAnyRole(Admin::getAllImportantRoles())) {

                 // Récupérer le nombre total de demandes
                $totalDocuments = Demande::count();

                // Calculer le montant total basé sur les montants des types de documents demandés
                $totalAmount = Demande::with('typeDocument')->get()->sum(function ($demande) {
                    return $demande->typeDocument->montant;
                });

                // Obtenir le nombre total de documents demandés pour la direction APIP
                $apipDocumentsCount = Demande::whereHas('typeDocument', function ($query) {
                    $query->where('id_direction', 1); // Remplacez 1 par l'ID de la direction APIP
                })->count();

                // Calculer le montant total des demandes de la direction APIP
                    $apipTotalAmount = Demande::whereHas('typeDocument', function ($query) {
                        $query->where('id_direction', 1);
                    })->join('type_documents', 'demandes.id_type_document', '=', 'type_documents.id_type_document')
                    ->sum('type_documents.montant'); // Somme des montants dans type_documents

                // Obtenir le nombre total de documents demandés pour la direction AGUIPEX
                $aguipexDocumentsCount = Demande::whereHas('typeDocument', function ($query) {
                    $query->where('id_direction', 2); // Remplacez 2 par l'ID de la direction AGUIPEX
                })->count();

                // Calculer le montant total des demandes de la direction AGUIPEX
                    $aguipexTotalAmount = Demande::whereHas('typeDocument', function ($query) {
                        $query->where('id_direction', 2);
                    })->join('type_documents', 'demandes.id_type_document', '=', 'type_documents.id_type_document')
                    ->sum('type_documents.montant'); // Somme des montants dans type_documents

                // Obtenir le nombre total de documents demandés pour la direction DNI
                $dniDocumentsCount = Demande::whereHas('typeDocument', function ($query) {
                    $query->where('id_direction', 3); // Remplacez 3 par l'ID de la direction dni
                })->count();

                // Calculer le montant total des demandes de la direction DNI
                    $dniTotalAmount = Demande::whereHas('typeDocument', function ($query) {
                        $query->where('id_direction', 3);
                    })->join('type_documents', 'demandes.id_type_document', '=', 'type_documents.id_type_document')
                    ->sum('type_documents.montant'); // Somme des montants dans type_documents

                   // Obtenir le nombre total de documents demandés pour la direction IGNM
                   $ignmDocumentsCount = Demande::whereHas('typeDocument', function ($query) {
                    $query->where('id_direction', 4); // Remplacez 4 par l'ID de la direction ignm
                    })->count();

                // Calculer le montant total des demandes de la direction IGNM
                    $ignmTotalAmount = Demande::whereHas('typeDocument', function ($query) {
                        $query->where('id_direction', 4);
                    })->join('type_documents', 'demandes.id_type_document', '=', 'type_documents.id_type_document')
                    ->sum('type_documents.montant'); // Somme des montants dans type_documents


                    // Obtenir le nombre total de documents demandés pour la direction DDI-DDE
                   $ddiddeDocumentsCount = Demande::whereHas('typeDocument', function ($query) {
                    $query->where('id_direction', 5); // Remplacez 5 par l'ID de la direction ddidde
                    })->count();

                // Calculer le montant total des demandes de la direction DDI-DDE
                    $ddiddeTotalAmount = Demande::whereHas('typeDocument', function ($query) {
                        $query->where('id_direction', 5);
                    })->join('type_documents', 'demandes.id_type_document', '=', 'type_documents.id_type_document')
                    ->sum('type_documents.montant'); // Somme des montants dans type_documents

                    // Obtenir le nombre total de documents demandés pour la directionDNCIC
                    $dncicDocumentsCount = Demande::whereHas('typeDocument', function ($query) {
                     $query->where('id_direction', 6); // Remplacez 6 par l'ID de la direction dncic
                     })->count();
 
                 // Calculer le montant total des demandes de la direction DNCIC
                     $dncicTotalAmount = Demande::whereHas('typeDocument', function ($query) {
                         $query->where('id_direction', 6);
                     })->join('type_documents', 'demandes.id_type_document', '=', 'type_documents.id_type_document')
                     ->sum('type_documents.montant'); // Somme des montants dans type_documents

                // Obtenir le nombre total de documents demandés pour la direction ONCQ
                $oncqDocumentsCount = Demande::whereHas('typeDocument', function ($query) {
                    $query->where('id_direction', 6); // Remplacez 6 par l'ID de la direction oncq
                    })->count();

                // Calculer le montant total des demandes de la direction ONCQ
                    $oncqTotalAmount = Demande::whereHas('typeDocument', function ($query) {
                        $query->where('id_direction', 6);
                    })->join('type_documents', 'demandes.id_type_document', '=', 'type_documents.id_type_document')
                    ->sum('type_documents.montant'); // Somme des montants dans type_documents
                return view('backend.pages.dashboard', 
                compact(
                    'apipDocumentsCount',
                    'apipTotalAmount',
                    'aguipexDocumentsCount',
                    'aguipexTotalAmount',
                    'dniDocumentsCount',
                    'dniTotalAmount',
                    'ignmDocumentsCount',
                    'ignmTotalAmount',
                    'ddiddeDocumentsCount',
                    'ddiddeTotalAmount',
                    'dncicDocumentsCount',
                    'dncicTotalAmount',
                    'oncqDocumentsCount',
                    'oncqTotalAmount',
                    'totalDocuments',
                     'totalAmount',
                    ));
            }
            return back();
        }
        return to_route('login')->with('warning', "Vous n'êtes pas connecté.");
    }

    public function detailDashboard($id_direction)
    {
        $directions = Direction::where('etat', 1)->get();

        $type_documents = TypeDocument::where('etat', 1)->get();

        // Obtenez les informations sur la direction sélectionnée
        $documentsCount = Demande::whereHas('typeDocument', function ($query) use ($id_direction) {
            $query->where('id_direction', $id_direction);
        })->count();
    
        $totalAmount = Demande::whereHas('typeDocument', function ($query) use ($id_direction) {
            $query->where('id_direction', $id_direction);
        })->join('type_documents', 'demandes.id_type_document', '=', 'type_documents.id_type_document')
        ->sum('type_documents.montant'); 
    
        // Obtenez les documents détaillés pour cette direction
        $documents = Demande::whereHas('typeDocument', function ($query) use ($id_direction) {
            $query->where('id_direction', $id_direction);
        })->get();
    
        // Vous pouvez aussi obtenir d'autres détails spécifiques à la direction ici
    
        return view('backend.pages.detail_dashboard', compact('documentsCount', 'totalAmount', 'documents', 'directions', 'type_documents'));
    }
    
    
}
