<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreCategorieDocumentRequest;
use App\Http\Requests\UpdateCategorieDocumentRequest;
use App\Models\CategorieDocument;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CategorieDocumentController extends Controller
{
    public function index()
    {
        $categories = CategorieDocument::where('etat', 1)->paginate(10);
        return view('backend.pages.categorie_documents.list', compact('categories'));
    }

    public function create()
    {
        return view('backend.pages.categorie_documents.add');
    }

    // Enregistrer une catégorie de document
    public function store(StoreCategorieDocumentRequest $request)
    {
        try {
            $categorie = new CategorieDocument();
            $categorie->libelle = $request->libelle;
            $categorie->etat = 1; // Catégorie activée par défaut
            $categorie->user_id = Auth::id();
            $categorie->save();
            
            return redirect()->route('categorie_document.index')->with('success', 'Catégorie enregistrée avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de l'enregistrement de la catégorie.");
        }
    }

    public function edit(CategorieDocument $categorie)
    {
        return view('backend.pages.categorie_documents.edit', compact('categorie'));
    }

    // Mettre à jour une catégorie de document existante
    public function update(UpdateCategorieDocumentRequest $request, CategorieDocument $categorie)
    {
        try {
            // Mise à jour des champs de la catégorie
            $categorie->libelle = $request->libelle;
            $categorie->save();

            return redirect()->route('categorie_document.index')->with('success', 'Catégorie mise à jour avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de la mise à jour de la catégorie.");
        }
    }

    // Désactiver une catégorie de document (état à 0)
    public function disable(CategorieDocument $categorie)
    {
        try {
            // Définir l'état à 0 pour désactiver la catégorie
            $categorie->etat = 0;
            $categorie->save();

            return redirect()->route('categorie_document.index')->with('success', 'Catégorie désactivée avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de la désactivation de la catégorie.");
        }
    }
}
