<?php

namespace App\Http\Controllers\Backend;

use Admin;
use App\Notifications\Demande\PromoteurDemandeNotification;
use Exception;
use Utilities;
use App\Models\User;
use App\Models\Demande;
use App\Models\Direction;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Models\DemandeRejetee;
use App\Models\DemandeService;
use App\Models\DemandeTraitee;
use App\Models\DemandeRenvoyee;
use App\Models\DemandeDirection;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\Admin\DemandeProcessRequest;
use App\Notifications\Demande\DemandeNotification;
use App\Notifications\Demande\DemandeRejectNotification;
use App\Notifications\Demande\DemandeReturnNotification;
use App\Notifications\Demande\DemandeProcessNotification;

class AdminDemandeController extends Controller
{
    public function index()
    {
        if (Auth::user()->hasAnyRole(Admin::getAllImportantRoles())) {
            try {
                $user = auth()->user();
                $directions = Direction::all();
                $IdDemandes = [];
                $demandes = null;

                # SuperAdmin/Admin
                if ($user->hasAnyRole(['super_admin', 'admin'])) {
                    $demandes = Demande::all();
                    $demandesOrientation = Demande::where(['id_statut_demande' => 1])->get();
                    $demandesEtude = Demande::where(['id_statut_demande' => 2])->get();
                    $demandesExamen = Demande::where(['id_statut_demande' => 3])->get();
                    $demandesModification = Demande::where(['id_statut_demande' => 4])->get();
                    $demandesRejet = Demande::where(['id_statut_demande' => 5])->get();
                    $demandesTraitees = Demande::where(['id_statut_demande' => 6])->get();
                    return view('backend.pages.demandes.list-of-demandes', compact('demandes', 'demandesOrientation', 'demandesEtude', 'demandesExamen', 'demandesModification', 'demandesRejet', 'demandesTraitees', 'directions'));
                }

                # Ministre
                if ($user->hasRole('ministre')) {
                    $demandes = Demande::all();
                    $demandesOrientation = Demande::where(['id_statut_demande' => 1])->get();
                    $demandesEtude = Demande::where(['id_statut_demande' => 2])->get();
                    $demandesExamen = Demande::where(['id_statut_demande' => 3])->get();
                    $demandesModification = Demande::where(['id_statut_demande' => 4])->get();
                    $demandesRejet = Demande::where(['id_statut_demande' => 5])->get();
                    $demandesTraitees = Demande::where(['id_statut_demande' => 6])->get();
                    return view('backend.pages.demandes.list-of-demandes', compact('demandes', 'demandesOrientation', 'demandesEtude', 'demandesExamen', 'demandesModification', 'demandesRejet', 'demandesTraitees', 'directions'));
                }
                # DNI
                if ($user->hasRole('dni')) {
                    $demandesDirections = DemandeDirection::where('id_direction', 1)->where('etat', 1)->get();
                    if ($demandesDirections->count() > 0) {
                        foreach ($demandesDirections as $demandeDirection) {
                            $IdDemandes[] = $demandeDirection->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # IGNM
                if ($user->hasRole('ignm')) {
                    $demandesDirections = DemandeDirection::where('id_direction', 2)->where('etat', 1)->get();
                    if ($demandesDirections->count() > 0) {
                        foreach ($demandesDirections as $demandeDirection) {
                            $IdDemandes[] = $demandeDirection->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # APIP
                if ($user->hasRole('apip')) {
                    $demandesDirections = DemandeDirection::where('id_direction', 3)->where('etat', 1)->get();
                    if ($demandesDirections->count() > 0) {
                        foreach ($demandesDirections as $demandeDirection) {
                            $IdDemandes[] = $demandeDirection->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # AGUIPEX
                if ($user->hasRole('aguipex')) {
                    $demandesDirections = DemandeDirection::where('id_direction', 4)->where('etat', 1)->get();
                    if ($demandesDirections->count() > 0) {
                        foreach ($demandesDirections as $demandeDirection) {
                            $IdDemandes[] = $demandeDirection->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # DNCIC
                if ($user->hasRole('dncic')) {
                    $demandesDirections = DemandeDirection::where('id_direction', 5)->where('etat', 1)->get();
                    if ($demandesDirections->count() > 0) {
                        foreach ($demandesDirections as $demandeDirection) {
                            $IdDemandes[] = $demandeDirection->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # ONCQ
                if ($user->hasRole('oncq')) {
                    $demandesDirections = DemandeDirection::where('id_direction', 6)->where('etat', 1)->get();
                    if ($demandesDirections->count() > 0) {
                        foreach ($demandesDirections as $demandeDirection) {
                            $IdDemandes[] = $demandeDirection->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # DDI-DDE
                if ($user->hasRole('ddi_dde')) {
                    $demandesDirections = DemandeDirection::where('id_direction', 7)->where('etat', 1)->get();
                    if ($demandesDirections->count() > 0) {
                        foreach ($demandesDirections as $demandeDirection) {
                            $IdDemandes[] = $demandeDirection->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # Service DNI
                if ($user->hasRole('service_dni')) {
                    $demandesServices = DemandeService::where('id_service', 1)->where('etat', 1)->get();
                    if ($demandesServices->count() > 0) {
                        foreach ($demandesServices as $demandeService) {
                            $IdDemandes[] = $demandeService->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # Service IGNM
                if ($user->hasRole('service_ignm')) {
                    $demandesServices = DemandeService::where('id_service', 2)->where('etat', 1)->get();
                    if ($demandesServices->count() > 0) {
                        foreach ($demandesServices as $demandeService) {
                            $IdDemandes[] = $demandeService->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # APIP - Service Code Investissement
                if ($user->hasRole('service_code_investissement')) {
                    $demandesServices = DemandeService::where('id_service', 3)->where('etat', 1)->get();
                    if ($demandesServices->count() > 0) {
                        foreach ($demandesServices as $demandeService) {
                            $IdDemandes[] = $demandeService->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # APIP - Guichet Unique Création Entreprise
                if ($user->hasRole('guichet_unique_creation_entreprise')) {
                    $demandesServices = DemandeService::where('id_service', 4)->where('etat', 1)->get();
                    if ($demandesServices->count() > 0) {
                        foreach ($demandesServices as $demandeService) {
                            $IdDemandes[] = $demandeService->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # AGUIPEX - Département Certification et Réglementation
                if ($user->hasRole('departement_certification_reglementation')) {
                    $demandesServices = DemandeService::where('id_service', 5)->where('etat', 1)->get();
                    if ($demandesServices->count() > 0) {
                        foreach ($demandesServices as $demandeService) {
                            $IdDemandes[] = $demandeService->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # Service DNCIC
                if ($user->hasRole('service_dncic')) {
                    $demandesServices = DemandeService::where('id_service', 6)->where('etat', 1)->get();
                    if ($demandesServices->count() > 0) {
                        foreach ($demandesServices as $demandeService) {
                            $IdDemandes[] = $demandeService->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # Service ONCQ
                if ($user->hasRole('service_oncq')) {
                    $demandesServices = DemandeService::where('id_service', 7)->where('etat', 1)->get();
                    if ($demandesServices->count() > 0) {
                        foreach ($demandesServices as $demandeService) {
                            $IdDemandes[] = $demandeService->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                # Service DDI-DDE
                if ($user->hasRole('service_ddi_dde')) {
                    $demandesServices = DemandeService::where('id_service', 8)->where('etat', 1)->get();
                    if ($demandesServices->count() > 0) {
                        foreach ($demandesServices as $demandeService) {
                            $IdDemandes[] = $demandeService->id_demande;
                        }
                    }
                    $demandes = Demande::whereIn('id_demande', $IdDemandes)->where('etat', 1)->get();
                }
                return view('backend.pages.demandes.list-of-demandes', compact('demandes', 'directions'));
            } catch (Exception $e) {
                dd($e->getMessage());
            }
        }
        return back();

    }
    public function demandeCategory($slug)
    {
        switch ($slug) {
            case "processing":
                # Liste des demandes en attente de traitement
                $demandes = Demande::where('id_statut_demande', 1)->get();
                return view('backend.pages.demandes.categories.processing', compact('demandes'));
            case "study":
                # Liste des demandes en attente d'étude
                $demandes = Demande::where('id_statut_demande', 2)->get();
                return view('backend.pages.demandes.categories.study', compact('demandes'));
            case "review":
                # Liste des demandes en attente d'examen
                $demandes = Demande::where('id_statut_demande', 3)->get();
                ;
                return view('backend.pages.demandes.categories.review', compact('demandes'));
            case "modification":
                # Liste des demandes en attente de modification
                $demandes = DemandeRenvoyee::with([
                    'demande' => function ($query) {
                        $query->where('id_statut_demande', 4);
                    }
                ])
                    ->get()
                    ->filter(function ($demandeRenvoyee) {
                        return $demandeRenvoyee->demande !== null;
                    })
                    ->unique('id_demande');
                return view('backend.pages.demandes.categories.modification', compact('demandes'));
            case "rejected":
                # Liste des demandes rejetées
                $demandes = DemandeRejetee::select('demande_rejetees.*')
                    ->join('demandes', 'demandes.id_demande', '=', 'demande_rejetees.id_demande')
                    ->where('demandes.id_statut_demande', 5)
                    ->get();
                return view('backend.pages.demandes.categories.rejected', compact('demandes'));
            case "processed":
                # Liste des demandes traitées
                $demandes = DemandeTraitee::select('demande_traitees.*')
                    ->join('demandes', 'demandes.id_demande', '=', 'demande_traitees.id_demande')
                    ->where('demandes.id_statut_demande', 6)
                    ->get();
                return view('backend.pages.demandes.categories.processed', compact('demandes'));
            default:
                return view('frontend.pages.demandes.list', compact('allDemandes'));
        }
    }
    public function orient(Demande $demande)
    {
        try {
            $user = auth()->user();
            # Ministre
            if ($user->hasRole('ministre')) {
                $direction = $demande->typeDocument->direction;
                $demandes = Demande::where('id_demande', $demande->id_demande)->where('id_statut_demande', 1)->where('etat', 1)->get();
                if ($demandes->count() > 0) {
                    foreach ($demandes as $demande) {
                        $orientation = new DemandeDirection();
                        $orientation->id_demande = $demande->id_demande;
                        $orientation->id_direction = $direction->id_direction;
                        $orientation->date_orientation = now();
                        $orientation->id_statut_demande = 2; // 2 = En attente d'étude
                        $orientation->date_orientation = now();
                        $orientation->save();
                        # Changer le statut de la demande
                        $demande->update(['id_statut_demande' => 2]); // 2 = En attente d'étude

                        $userPromoteur = $demande->promoteur->user;
                        $messagePromoteur = "Votre demande est en attente d'étude au niveau de $direction->nom";
                        $messageDirection = "Vous avez une demande en attente d'étude.";
                        Notification::create([
                            'user_id' => $userPromoteur->user_id,
                            'message' => $messagePromoteur,
                        ]);
                        $userPromoteur->notify(new PromoteurDemandeNotification($messagePromoteur));

                        switch ($direction->id_direction) {
                            # DNI
                            case 1:
                                $userDirection = User::select('user_id', 'email')->where('email', 'dg.dni@mail.com')->first();

                                Notification::create([
                                    'user_id' => $userDirection->user_id,
                                    'message' => $messageDirection,
                                ]);
                                $userDirection->notify(new DemandeNotification($messageDirection));
                                break;
                            # IGNM
                            case 2:
                                $userDirection = User::select('user_id', 'email')->where('email', 'dg.ignm@mail.com')->first();

                                Notification::create([
                                    'user_id' => $userDirection->user_id,
                                    'message' => $messageDirection,
                                ]);
                                $userDirection->notify(new DemandeNotification($messageDirection));
                                break;
                            # APIP
                            case 3:
                                $userDirection = User::select('user_id', 'email')->where('email', 'dg.apip@mail.com')->first();

                                Notification::create([
                                    'user_id' => $userDirection->user_id,
                                    'message' => $messageDirection,
                                ]);
                                $userDirection->notify(new DemandeNotification($messageDirection));
                                break;
                            # AGUIPEX
                            case 4:
                                $userDirection = User::select('user_id', 'email')->where('email', 'dg.aguipex@mail.com')->first();

                                Notification::create([
                                    'user_id' => $userDirection->user_id,
                                    'message' => $messageDirection,
                                ]);
                                $userDirection->notify(new DemandeNotification($messageDirection));
                                break;
                            # DNCIC
                            case 5:
                                $userDirection = User::select('user_id', 'email')->where('email', 'dg.dncic@mail.com')->first();

                                Notification::create([
                                    'user_id' => $userDirection->user_id,
                                    'message' => $messageDirection,
                                ]);
                                $userDirection->notify(new DemandeNotification($messageDirection));
                                break;
                            # ONCQ
                            case 6:
                                $userDirection = User::select('user_id', 'email')->where('email', 'dg.oncq@mail.com')->first();

                                Notification::create([
                                    'user_id' => $userDirection->user_id,
                                    'message' => $messageDirection,
                                ]);
                                $userDirection->notify(new DemandeNotification($messageDirection));
                                break;
                            # DDI-DDE
                            case 7:
                                $userDirection = User::select('user_id', 'email')->where('email', 'dg.ddi.dde@mail.com')->first();

                                Notification::create([
                                    'user_id' => $userDirection->user_id,
                                    'message' => $messageDirection,
                                ]);
                                $userDirection->notify(new DemandeNotification($messageDirection));
                                break;

                        }
                    }

                    return back()->with('success', "Demande orienté avec succès vers $direction->nom");
                }
                return back()->with('warning', "Demande déjà orienté");
            }
            # Direction / EPA
            if ($user->hasAnyRole(Admin::getDirectionRoles())) {
                $service = $demande->typeDocument->service;
                $demandes = Demande::where('id_demande', $demande->id_demande)->where('id_statut_demande', 2)->where('etat', 1)->get();
                if ($demandes->count() > 0) {
                    foreach ($demandes as $demande) {
                        $orientation = new DemandeService();
                        $orientation->id_demande = $demande->id_demande;
                        $orientation->id_service = $service->id_service;
                        $orientation->date_orientation = now();
                        $orientation->id_statut_demande = 3; // 3 = En attente d'examen
                        $orientation->date_orientation = now();
                        $orientation->save();
                        # Changer le statut de la demande
                        $demande->update(['id_statut_demande' => 3]); // 3 = En attente d'examen

                        # Promoteur
                        $userPromoteur = $demande->promoteur->user;
                        $messagePromoteur = "Votre demande est en attente d'examen au niveau de $service->nom.";
                        Notification::create([
                            'user_id' => $userPromoteur->user_id,
                            'message' => $messagePromoteur,
                        ]);
                        $userPromoteur->notify(new PromoteurDemandeNotification($messagePromoteur));

                        # Ministre
                        $ministre = User::select('user_id', 'email')->where('email', 'ministre@mail.com')->first();
                        $ministreMessage = "La demande '$demande->titre_demande' est en attente d'examen au niveau de $service->nom.";
                        Notification::create([
                            'user_id' => $ministre->user_id,
                            'message' => $ministreMessage,
                        ]);
                        $ministre->notify(new DemandeNotification($ministreMessage));

                        # Service
                        $serviceMessage = "Vous avez une demande en attente d'examen.";

                        switch ($service->id_service) {
                            # Direction Nationale de l'Industrie
                            case 1:
                                # Service
                                $serviceUser = User::select('user_id', 'email')->where('email', 'cs.dni@mail.com')->first();
                                Notification::create([
                                    'user_id' => $serviceUser->user_id,
                                    'message' => $serviceMessage,
                                ]);
                                $serviceUser->notify(new DemandeNotification($serviceMessage));
                                break;
                            # Institut Guinéen de Normalisation et de Métrologie
                            case 2:
                                # Service
                                $serviceUser = User::select('user_id', 'email')->where('email', 'cs.ignm@mail.com')->first();
                                Notification::create([
                                    'user_id' => $serviceUser->user_id,
                                    'message' => $serviceMessage,
                                ]);
                                $serviceUser->notify(new DemandeNotification($serviceMessage));
                                break;
                            # Service Code des Investissements
                            case 3:
                                # Service
                                $serviceUser = User::select('user_id', 'email')->where('email', 'cs.cdi.apip@mail.com')->first();
                                Notification::create([
                                    'user_id' => $serviceUser->user_id,
                                    'message' => $serviceMessage,
                                ]);
                                $serviceUser->notify(new DemandeNotification($serviceMessage));
                                break;
                            # Guichet Unique de Création d'Entreprises
                            case 4:
                                # Service
                                $serviceUser = User::select('user_id', 'email')->where('email', 'cs.guce.apip@mail.com')->first();
                                Notification::create([
                                    'user_id' => $serviceUser->user_id,
                                    'message' => $serviceMessage,
                                ]);
                                $serviceUser->notify(new DemandeNotification($serviceMessage));
                                break;
                            # Département Certification et Réglementation
                            case 5:
                                # Service
                                $serviceUser = User::select('user_id', 'email')->where('email', 'cs.aguipex@mail.com')->first();
                                Notification::create([
                                    'user_id' => $serviceUser->user_id,
                                    'message' => $serviceMessage,
                                ]);
                                $serviceUser->notify(new DemandeNotification($serviceMessage));
                                break;
                            # Direction Natinale du Commerce Intérieur
                            case 6:
                                # Service
                                $serviceUser = User::select('user_id', 'email')->where('email', 'cs.dncic@mail.com')->first();
                                Notification::create([
                                    'user_id' => $serviceUser->user_id,
                                    'message' => $serviceMessage,
                                ]);
                                $serviceUser->notify(new DemandeNotification($serviceMessage));
                                break;
                            # Office National Control et Qualité
                            case 7:
                                # Service
                                $serviceUser = User::select('user_id', 'email')->where('email', 'cs.oncq@mail.com')->first();
                                Notification::create([
                                    'user_id' => $serviceUser->user_id,
                                    'message' => $serviceMessage,
                                ]);
                                $serviceUser->notify(new DemandeNotification($serviceMessage));
                                break;
                            # DDI-DDE
                            case 8:
                                # Service
                                $serviceUser = User::select('user_id', 'email')->where('email', 'cs.ddi.dde@mail.com')->first();
                                Notification::create([
                                    'user_id' => $serviceUser->user_id,
                                    'message' => $serviceMessage,
                                ]);
                                $serviceUser->notify(new DemandeNotification($serviceMessage));
                                break;
                        }
                    }
                    return back()->with('success', "Demande orienté avec succès vers $service->nom");
                }
                return back()->with('warning', "Demande déjà orienté");
            }
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }
    public function reject(Request $request, Demande $demande)
    {
        if (!isset($request->motif)) {
            return back()->with('warning', "Vous devez renseigner le motif du rejet.");
        }
        try {
            $user = auth()->user();
            # Ministre
            if ($user->hasRole('ministre')) {
                $demande = Demande::findOrFail($demande->id_demande);
                if ($demande->id_statut_demande == 1) {
                    $demandesRejetees = new DemandeRejetee();
                    $demandesRejetees->id_demande = $demande->id_demande;
                    $demandesRejetees->motif_rejet = $request->motif;
                    $demandesRejetees->date_rejet = now();
                    $demandesRejetees->save();
                    # Changer le statut de la demande
                    $demande->update(['id_statut_demande' => 5]); // 5 = Demande Rejetée

                    $promoteur = $demande->promoteur->user;
                    $promoteur->notify(new DemandeRejectNotification($request->motif));

                    return back()->with('success', "Demande rejetée avec succès.");
                } elseif ($demande->id_statut_demande <> 1) {
                    return back()->with('warning', "Cette demande ne pas être rejeter, car elle est dans le processus de traitement.");
                } else {
                    return back()->with('warning', "Cette demande n'existe pas.");
                }
            }
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }
    public function show(Demande $demande)
    {
        if (Auth::user()->hasAnyRole(Admin::getAllImportantRoles())) {
            return view('backend.pages.demandes.demande-details', compact('demande'));
        }
        return back();
    }
    public function return(Demande $demande)
    {
        try {
            $demande = Demande::findOrFail($demande->id_demande);
            return view('backend.pages.demandes.return', compact('demande'));
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }
    public function validateReturn(Request $request, Demande $demande)
    {
        if (!isset($request->motif) && !$request->hasFile('attachments')) {
            return back()->with('warning', "Vous devez soit joindre un document, soit renseigner le motif du renvoi.");
        }
        if (Auth::user()->hasAnyRole(Admin::getAllImportantRoles())) {
            $direction = $demande->typeDocument->direction;
            $demande = Demande::findOrFail($demande->id_demande);
            if ($demande->id_statut_demande == 3) {
                $demandesRenvoyees = new DemandeRenvoyee();
                $demandesRenvoyees->id_demande = $demande->id_demande;
                $demandesRenvoyees->motif_renvoi = $request->motif ?? NULL;
                $files = [];
                if ($request->hasFile('attachments')) {
                    $files = Utilities::setFiles($request->file('attachments'), 'documents_recus');
                }
                $demandesRenvoyees->documents_joints = $files;
                $demandesRenvoyees->date_renvoi = now();
                $demandesRenvoyees->save();
                # Changer le statut de la demande
                $demande->update(['id_statut_demande' => 4]); // 4 = Demande Renvoyée
                $demandeDirection = DemandeDirection::where('id_demande', $demande->id_demande)->first();
                $demandeDirection->id_statut_demande = 4; // 4 = Demande Renvoyée
                $demandeDirection->update();
                $demandeService = DemandeService::where('id_demande', $demande->id_demande)->first();
                $demandeService->id_statut_demande = 4; // 4 = Demande Renvoyée
                $demandeService->update();

                # Promoteur
                $userPromoteur = $demande->promoteur->user;
                $messagePromoteur = "Votre demande '$demande->titre_demande' est renvoyée en modification pour complément d’information.";
                Notification::create([
                    'user_id' => $userPromoteur->user_id,
                    'message' => $messagePromoteur,
                ]);
                $userPromoteur->notify(new DemandeReturnNotification($files));

                # Ministre
                $ministreMessage = "La demande '$demande->titre_demande' est renvoyée en modification pour complément d’information.";
                $ministre = User::select('user_id', 'email')->where('email', 'ministre@mail.com')->first();
                Notification::create([
                    'user_id' => $ministre->user_id,
                    'message' => $ministreMessage,
                ]);
                $ministre->notify(new DemandeNotification($ministreMessage));

                # Direction
                $messageDirection = "La demande '$demande->titre_demande' est renvoyée en modification pour complément d’information.";

                switch ($direction->id_direction) {
                    # DNI
                    case 1:
                        $userDirection = User::select('user_id', 'email')->where('email', 'dg.dni@mail.com')->first();

                        Notification::create([
                            'user_id' => $userDirection->user_id,
                            'message' => $messageDirection,
                        ]);
                        $userDirection->notify(new DemandeNotification($messageDirection));
                        break;
                    # IGNM
                    case 2:
                        $userDirection = User::select('user_id', 'email')->where('email', 'dg.ignm@mail.com')->first();

                        Notification::create([
                            'user_id' => $userDirection->user_id,
                            'message' => $messageDirection,
                        ]);
                        $userDirection->notify(new DemandeNotification($messageDirection));
                        break;
                    # APIP
                    case 3:
                        $userDirection = User::select('user_id', 'email')->where('email', 'dg.apip@mail.com')->first();

                        Notification::create([
                            'user_id' => $userDirection->user_id,
                            'message' => $messageDirection,
                        ]);
                        $userDirection->notify(new DemandeNotification($messageDirection));
                        break;
                    # AGUIPEX
                    case 4:
                        $userDirection = User::select('user_id', 'email')->where('email', 'dg.aguipex@mail.com')->first();

                        Notification::create([
                            'user_id' => $userDirection->user_id,
                            'message' => $messageDirection,
                        ]);
                        $userDirection->notify(new DemandeNotification($messageDirection));
                        break;
                    # DNCIC
                    case 5:
                        $userDirection = User::select('user_id', 'email')->where('email', 'dg.dncic@mail.com')->first();

                        Notification::create([
                            'user_id' => $userDirection->user_id,
                            'message' => $messageDirection,
                        ]);
                        $userDirection->notify(new DemandeNotification($messageDirection));
                        break;
                    # ONCQ
                    case 6:
                        $userDirection = User::select('user_id', 'email')->where('email', 'dg.oncq@mail.com')->first();

                        Notification::create([
                            'user_id' => $userDirection->user_id,
                            'message' => $messageDirection,
                        ]);
                        $userDirection->notify(new DemandeNotification($messageDirection));
                        break;
                    # DDI-DDE
                    case 7:
                        $userDirection = User::select('user_id', 'email')->where('email', 'dg.ddi.dde@mail.com')->first();

                        Notification::create([
                            'user_id' => $userDirection->user_id,
                            'message' => $messageDirection,
                        ]);
                        $userDirection->notify(new DemandeNotification($messageDirection));
                        break;
                }

                return redirect()->route('dashboard.demande.list')->with('success', "La demande a bien été renvoyée pour modification.");
            } else {
                return back()->with('warning', "Cette action est impossible.");
            }
        }
        return back();
    }
    public function edit(Demande $demande)
    {
        return view('frontend.pages.demandes.edit-demande', compact('demande'));
    }
    public function update(Request $request, Demande $demande)
    {
        if (!$request->hasFile('attachments')) {
            return back()->with('warning', "Vous devez joindre les documents nécessaires.");
        }
        try {
            $files = [];
            if ($request->hasFile('attachments')) {
                $files = Utilities::setFiles($request->file('attachments'), 'documents_recus');
            }
            # Changer le statut de la demande
            $demande->update([
                'documents_joints' => $files,
                'id_statut_demande' => 3 // 3 = Demande En attente d'examen
            ]); // 4 = Demande Renvoyée
            $demandeDirection = DemandeDirection::where('id_demande', $demande->id_demande)->first();
            $demandeDirection->id_statut_demande = 3; // 3 = Demande En attente d'examen
            $demandeDirection->update();
            $demandeService = DemandeService::where('id_demande', $demande->id_demande)->first();
            $demandeService->id_statut_demande = 3; // 3 = Demande En attente d'examen
            $demandeService->update();

            # Service
            $service = $demande->typeDocument->service;
            $serviceMessage = "La demande '$demande->titre_demande' a été modifiée. Veuillez procéder à l'examen.";

            switch ($service->id_service) {
                # Direction Nationale de l'Industrie
                case 1:
                    # Service
                    $serviceUser = User::select('user_id', 'email')->where('email', 'cs.dni@mail.com')->first();
                    Notification::create([
                        'user_id' => $serviceUser->user_id,
                        'message' => $serviceMessage,
                    ]);
                    $serviceUser->notify(new DemandeNotification($serviceMessage));
                    break;
                # Institut Guinéen de Normalisation et de Métrologie
                case 2:
                    # Service
                    $serviceUser = User::select('user_id', 'email')->where('email', 'cs.ignm@mail.com')->first();
                    Notification::create([
                        'user_id' => $serviceUser->user_id,
                        'message' => $serviceMessage,
                    ]);
                    $serviceUser->notify(new DemandeNotification($serviceMessage));
                    break;
                # Service Code des Investissements
                case 3:
                    # Service
                    $serviceUser = User::select('user_id', 'email')->where('email', 'cs.cdi.apip@mail.com')->first();
                    Notification::create([
                        'user_id' => $serviceUser->user_id,
                        'message' => $serviceMessage,
                    ]);
                    $serviceUser->notify(new DemandeNotification($serviceMessage));
                    break;
                # Guichet Unique de Création d'Entreprises
                case 4:
                    # Service
                    $serviceUser = User::select('user_id', 'email')->where('email', 'cs.guce.apip@mail.com')->first();
                    Notification::create([
                        'user_id' => $serviceUser->user_id,
                        'message' => $serviceMessage,
                    ]);
                    $serviceUser->notify(new DemandeNotification($serviceMessage));
                    break;
                # Département Certification et Réglementation
                case 5:
                    # Service
                    $serviceUser = User::select('user_id', 'email')->where('email', 'cs.aguipex@mail.com')->first();
                    Notification::create([
                        'user_id' => $serviceUser->user_id,
                        'message' => $serviceMessage,
                    ]);
                    $serviceUser->notify(new DemandeNotification($serviceMessage));
                    break;
                # Direction Natinale du Commerce Intérieur
                case 6:
                    # Service
                    $serviceUser = User::select('user_id', 'email')->where('email', 'cs.dncic@mail.com')->first();
                    Notification::create([
                        'user_id' => $serviceUser->user_id,
                        'message' => $serviceMessage,
                    ]);
                    $serviceUser->notify(new DemandeNotification($serviceMessage));
                    break;
                # Office National Control et Qualité
                case 7:
                    # Service
                    $serviceUser = User::select('user_id', 'email')->where('email', 'cs.oncq@mail.com')->first();
                    Notification::create([
                        'user_id' => $serviceUser->user_id,
                        'message' => $serviceMessage,
                    ]);
                    $serviceUser->notify(new DemandeNotification($serviceMessage));
                    break;
                # DDI-DDE
                case 8:
                    # Service
                    $serviceUser = User::select('user_id', 'email')->where('email', 'cs.ddi.dde@mail.com')->first();
                    Notification::create([
                        'user_id' => $serviceUser->user_id,
                        'message' => $serviceMessage,
                    ]);
                    $serviceUser->notify(new DemandeNotification($serviceMessage));
                    break;
            }

            return back()->with('success', "Demande modifiée avec succès.");
        } catch (Exception $e) {
            dd($e->getMessage());
        }

    }
    public function process(Demande $demande)
    {
        if (Auth::user()->hasAnyRole(Admin::getAllImportantRoles())) {
            return view('backend.pages.demandes.process-demande', compact('demande'));
        }
        return back();
    }
    public function validateProcess(DemandeProcessRequest $request, Demande $demande)
    {
        try {
            $user = Auth()->user();
            $traitement = new DemandeTraitee();
            $traitement->user_id = $user->id;
            $traitement->id_demande = $demande->id_demande;
            $traitement->id_promoteur = $demande->promoteur->id_promoteur;

            $files = [];

            if ($request->hasfile('attachments')) {
                foreach ($request->file('attachments') as $i => $file) {
                    // $file_name = time().''.$i.'.'.$file->getClientOriginalExtension();
                    $file_name = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME) . '-' . time() . $i;
                    $file_extension = $file->getClientOriginalExtension();
                    $file_size = filesize($file);
                    $allowed_files_extensions = ['pdf'];
                    $file_max_size = (100 * 1048576); // Taille max (100Mo)

                    if ($file_size > $file_max_size) {
                        return back()->with(['error' => 'Le document joint est trop volumineux.(' . ($file_max_size / 1048576) . 'Mo maximnum)']);
                    }

                    if (!in_array($file_extension, $allowed_files_extensions)) {
                        return back()->with('error', "Les documents joints doivent tous être au format (.pdf)");
                    }

                    $file->storeAs('documents_envoyes', $file_name, 'public');

                    $files[$i] = $file_name;
                }
            }
            $traitement->documents_joints = $files;
            $traitement->commentaire = $request->observation ?? NULL;
            $traitement->date_traitement = now();
            $traitement->save();
            # Changer le statut de la demande
            $demande->update(['id_statut_demande' => 6]); // 6 = Demande Traitée
            $demandeDirection = DemandeDirection::where('id_demande', $demande->id_demande)->first();
            $demandeDirection->id_statut_demande = 6; // 6 = Demande Traitée
            $demandeDirection->update();
            $demandeService = DemandeService::where('id_demande', $demande->id_demande)->first();
            $demandeService->id_statut_demande = 6; // 6 = Demande Traitée
            $demandeService->update();

            # Promoteur
            $userPromoteur = $demande->promoteur->user;
            $messagePromoteur = "Votre votre demande a bien été traitée.";
            Notification::create([
                'user_id' => $userPromoteur->user_id,
                'message' => $messagePromoteur,
            ]);
            $userPromoteur->notify(new DemandeProcessNotification($files, $messagePromoteur));

            # Ministre
            $ministreMessage = "La demande '$demande->titre_demande' a été traitée avec succès.";
            $ministre = User::select('user_id', 'email')->where('email', 'ministre@mail.com')->first();
            Notification::create([
                'user_id' => $ministre->user_id,
                'message' => $ministreMessage,
            ]);
            $ministre->notify(new DemandeNotification($ministreMessage));

            # Direction
            $messageDirection = "La demande '$demande->titre_demande' a été traitée avec succès.";
            $direction = $demande->typeDocument->direction;

            switch ($direction->id_direction) {
                # DNI
                case 1:
                    $userDirection = User::select('user_id', 'email')->where('email', 'dg.dni@mail.com')->first();

                    Notification::create([
                        'user_id' => $userDirection->user_id,
                        'message' => $messageDirection,
                    ]);
                    $userDirection->notify(new DemandeNotification($messageDirection));
                    break;
                # IGNM
                case 2:
                    $userDirection = User::select('user_id', 'email')->where('email', 'dg.ignm@mail.com')->first();

                    Notification::create([
                        'user_id' => $userDirection->user_id,
                        'message' => $messageDirection,
                    ]);
                    $userDirection->notify(new DemandeNotification($messageDirection));
                    break;
                # APIP
                case 3:
                    $userDirection = User::select('user_id', 'email')->where('email', 'dg.apip@mail.com')->first();

                    Notification::create([
                        'user_id' => $userDirection->user_id,
                        'message' => $messageDirection,
                    ]);
                    $userDirection->notify(new DemandeNotification($messageDirection));
                    break;
                # AGUIPEX
                case 4:
                    $userDirection = User::select('user_id', 'email')->where('email', 'dg.aguipex@mail.com')->first();

                    Notification::create([
                        'user_id' => $userDirection->user_id,
                        'message' => $messageDirection,
                    ]);
                    $userDirection->notify(new DemandeNotification($messageDirection));
                    break;
                # DNCIC
                case 5:
                    $userDirection = User::select('user_id', 'email')->where('email', 'dg.dncic@mail.com')->first();

                    Notification::create([
                        'user_id' => $userDirection->user_id,
                        'message' => $messageDirection,
                    ]);
                    $userDirection->notify(new DemandeNotification($messageDirection));
                    break;
                # ONCQ
                case 6:
                    $userDirection = User::select('user_id', 'email')->where('email', 'dg.oncq@mail.com')->first();

                    Notification::create([
                        'user_id' => $userDirection->user_id,
                        'message' => $messageDirection,
                    ]);
                    $userDirection->notify(new DemandeNotification($messageDirection));
                    break;
                # DDI-DDE
                case 7:
                    $userDirection = User::select('user_id', 'email')->where('email', 'dg.ddi.dde@mail.com')->first();

                    Notification::create([
                        'user_id' => $userDirection->user_id,
                        'message' => $messageDirection,
                    ]);
                    $userDirection->notify(new DemandeNotification($messageDirection));
                    break;
            }

            return redirect()->route('dashboard.demande.list')->with('success', "Demande traitée avec succès.");
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }
}
