<?php

namespace App\Http\Controllers\Auth;

use App\Models\Entity;
use App\Models\Promoteur;
use Exception;
use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Requests\Auth\RegisterUserRequest;
use App\Notifications\Auth\RegisterUserNotification;
use App\Models\Genre;

class RegisterController extends Controller
{
    public function create()
    {
        $genres = Genre::all();
        return view('auth.register', compact('genres'));
    }

    public function store(RegisterUserRequest $request)
    {
        try {
            $user = new User();
    
            $user->email = $request->email;
            $user->password = Hash::make($request->password, [
                'rounds' => 12,
            ]);
            $user->first_name = $request->first_name;
            $user->last_name = $request->last_name;
            $user->id_genre = $request->gender;
            $user->telephone = $request->telephone;
            $user->adresse = $request->address;
            $user->id_categorie_utilisateur = 4; // 4 = Promoteur
            $user->id_etat_utilisateur = 1; // 1 = Actif
            $user->save();

            $promoteur = new Promoteur();
            $promoteur->nom_entreprise = $request->company;
            $promoteur->user_id = $user->user_id;
            $promoteur->save();
            

            // Envoi de l'email de vérification
            $token = Str::random(60);
            DB::table('email_verifications')->insert([
                'email' => $user->email,
                'token' => $token,
                'created_at' => now(),
            ]);

            $user->assignRole('user');

            $user->notify(new RegisterUserNotification($token));

            return back()->with('success', "Votre inscription a bien été prise en compte. Merci de vérifier vos emails pour valider votre compte.");
        } catch (Exception $e) {
            // return response()->json($e);
            dd($e->getMessage());
        }
    }

    public function verifyEmail($token)
    {
        try {
            $verification = DB::table('email_verifications')->where('token', $token)->first();

            if ($verification) {
                $user = User::where('email', $verification->email)->first();
                $user->email_verified_at = now();
                $user->save();

                DB::table('email_verifications')->where('email', $verification->email)->delete();

                Auth::login($user);

                return redirect()->route('home')->with('success', 'Votre email a été vérifié avec succès.');
            }

            return redirect()->route('login')->with('error', 'Lien de vérification non valide.');
        } catch (Exception $e) {
            // return response()->json($e);
            dd($e->getMessage());
        }
    }
}
