<?php

namespace App\Http\Controllers\Auth;

use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Password;
use App\Http\Requests\Auth\ForgotPasswordRequest;

class ForgotPasswordController extends Controller
{
    public function showLinkRequestForm(Request $request)
    {
        return view('auth.forgot-password');
    }

    public function sendResetLinkEmail(ForgotPasswordRequest $request)
    {
        try {
            $status = Password::sendResetLink(
                $request->only('email')
            );

            return $status === Password::RESET_LINK_SENT
                        ? back()->with(['success' => "Nous vous avons envoyé par e-mail un lien de réinitialisation de votre mot de passe."])
                        : back()->withInput($request->only('email'))
                                ->withErrors(['email' => __($status)]);
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }
}
