<?php

namespace App\Http\Controllers\Auth;

use Exception;
use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\Auth\LoginUserRequest;

class AuthenticationController extends Controller
{
    public function create()
    {
        return view('auth.login');
    }

    public function store(LoginUserRequest $request)
    {
        try {
            $credentials = $request->only('email', 'password');
            $remember = $request->has('remember');

            $user = User::where('email', $credentials['email'])->first();

            if ($user && !$user->email_verified_at) {
                return back()->with('error', "Veuillez vérifier vos e-mails pour valider votre adresse e-mail.");
                // return back()->withErrors(['email' => 'Votre adresse email n\'est pas vérifiée.']);
            }

            if (Auth::attempt($credentials, $remember)) {
                $request->session()->regenerate();

                // return redirect()->intended(RouteServiceProvider::HOME);
                return to_route('home')->with('success', "Vous êtes maintenant connecté.");
            }
            else {
                return back()->with('error', "Informations de connexion non valides.");
                // return back()->withErrors([
                //     'email' => 'Les informations d\'identification fournies ne correspondent pas à nos dossiers.',
                // ]);
            }

        } catch (Exception $e) {
            // return response()->json($e);
            dd($e->getMessage());
        }
    }

    public function destroy(Request $request)
    {
        Auth::logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/')->with('info', "Vous avez été déconnecté!");
    }
}
