<?php

use Hashids\Hashids;

class Utilities
{
    # Encoder l'id dans une URL
    public static function encodeId($id)
    {
        $hashids = new Hashids('', 16, 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890');
        return $hashids->encode($id);
    }
    # Décoder l'id dans une URL
    public static function decodeId($id)
    {
        $hashids = new Hashids('', 16, 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890');
        return $hashids->decode($id);
    }
    public static function setDay($date)
    {
        return (new DateTime($date))->format('d');
    }
    public static function setMonth($date)
    {
        $month = (new DateTime($date))->format('m');
        $mois = null;
        switch ($month) {
            case 1:
                return 'Janvier';
            case 2:
                return 'Février';
            case 3:
                return 'Mars';
            case 4:
                return 'Avril';
            case 5:
                return 'Mai';
            case 6:
                return 'Juin';
            case 7:
                return 'Juillet';
            case 8:
                return 'Août';
            case 9:
                return 'Septembre';
            case 10:
                return 'Octobre';
            case 11:
                return 'Novembre';
            case 12:
                return 'Décembre';
        }
    }
    public static function setYear($date)
    {
        return (new DateTime($date))->format('Y');
    }
    public static function formatDate($date)
    {
        return static::setDay($date) . ' ' . static::setMonth($date) . ' ' . static::setYear($date);
    }
    public static function setFiles($file_names, $directory)
    {
        $files = [];
        foreach ($file_names as $i => $file) {
            // $file_name = time().''.$i.'.'.$file->getClientOriginalExtension();
            $file_name = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME) . '-' . time() . $i;
            $file_extension = $file->getClientOriginalExtension();
            $file_size = filesize($file);
            $allowed_files_extensions = ['doc', 'docx', 'xls', 'xlsx', 'pptx', 'txt', 'pdf', 'png', 'jpg', 'jpeg'];
            $file_max_size = (100 * 1048576); // Taille max (100Mo)

            if ($file_size > $file_max_size) {
                return back()->with(['error' => 'Le document joint est trop volumineux.(' . ($file_max_size / 1048576) . 'Mo maximnum)']);
            }

            if (!in_array($file_extension, $allowed_files_extensions)) {
                return back()->with('error', "Les documents joints doivent avoir une des extensions suivantes : (.doc, .docx, .xls, .xlsx, .txt, .pdf,  .png, .jpg, .jpeg)");
            }

            $file->storeAs($directory, $file_name, 'public');

            $files[$i] = $file_name;
        }
        return $files;
    }
}