<?php

use Spatie\Permission\Models\Role;

class Admin {
    public static function getAdminRoles() {
        return [
            'super_admin',
            'admin'
        ];
    }

    public static function getManagerRoles() {
        return [
            'super_admin',
            'admin',
            'superviseur',
            'ministre',
            'chef_cabinet',
            'secretaire_general',
            'directeur',
            'chef_service',
            'chef_section'
        ];
    }

    public static function getDirectionRoles() {
        return [
            'dni',
            'ignm',
            'apip',
            'aguipex',
            'dncic',
            'oncq',
            'ddi_dde',
        ];
    }

    public static function getServiceRoles() {
        return [
            'service_dni',
            'service_ignm',
            'service_code_investissement',
            'guichet_unique_creation_entreprise',
            'departement_certification_reglementation',
            'service_dncic',
            'service_oncq',
            'service_ddi_dde',
        ];
    }

    public static function getAllRoles() {
        $allRoles =  Role::all();
        return $allRoles;
    }

    public static function getAllImportantRoles() {
        $allRoles =  Role::where('name', '<>', 'user')->get();
        return $allRoles;
    }
}